ORCA/M Asm65816 2.1.0

0001 3BEB                       title 'StatTextProc' 
0002 3BEB              **********************************************************************
0003 3BEB              *
0004 3BEB              * Static Text Control Def Proc
0005 3BEB              *
0006 3BEB              *
0007 3BEB              * Copyright (C)
0008 3BEB              * Apple Computer, Inc.  1986-1989
0009 3BEB              * All Rights Reserved
0010 3BEB              *
0011 3BEB              * 23 Sep 88         Steven Glass
0012 3BEB              *
0013 3BEB              * Coding began from modified version of Tech Support's custom
0014 3BEB              * control (by Keith Rollin).
0015 3BEB              *
0016 3BEB              * 10 Oct 88         Steven Glass
0017 3BEB              *
0018 3BEB              * Made memory allocation work correctly for the four cases: ptr, handle
0019 3BEB              * resource and offset.  Got drawing to work correctly for offset.
0020 3BEB              * Removed code that looked for errors from resource loads.  Locked
0021 3BEB              * and unlocked control handle around calls to LETextBox2 when text
0022 3BEB              * is in the control record.
0023 3BEB              *
0024 3BEB              * 23 Nov 88         Steven Glass
0025 3BEB              *
0026 3BEB              * Removed code that supports offsets.
0027 3BEB              *
0028 3BEB              * 06 Feb 89         Steven Glass
0029 3BEB              *
0030 3BEB              * Added support for initial justification being other than 0.
0031 3BEB              * Changed drawing routine to deref the control handle after 
0032 3BEB              * compiling text and drawing text.
0033 3BEB              *
0034 3BEB              * 22 Mar 89         Harry Yee
0035 3BEB              *
0036 3BEB              * Control handle was not being derefed enough times possibly allowing memory to move 
0037 3BEB              * and making pointer no longer valid. In routine ConvertRefToPtr added additional deref
0038 3BEB              * after GetHandleSize call.
0039 3BEB              *
0040 3BEB              * 28 Mar 89         Steven Glass
0041 3BEB              *
0042 3BEB              * Added support for the ctlWinStateChange message.  Message is ignored
0043 3BEB              * since this control does not look any different if it is in an active vs
0044 3BEB              * inactive window.
0045 3BEB              *
0046 3BEB              * 09 Apr 89         Harry Yee
0047 3BEB              *
0048 3BEB              * The 22 Mar 89 fix above didn't fix the bug. Problem was LETextBox2 moves memory!
0049 3BEB              * Since the control handle is unlocked, the ptr to the control rect passed to
0050 3BEB              * LETextBox2 could possibly become invalid after the first NewHandle call in 
0051 3BEB              * LETextBox2. We now make sure we lock the control's handle. BRC #46453.
0052 3BEB              *
0053 3BEB              * 4/13/89           Mensch
0054 3BEB              *
0055 3BEB              * The apr 09 fix caused a strange bug when the defproc is called for the rec size,
0056 3BEB              * it tries to unlock the control handle, but fails since the control handle
0057 3BEB              * does not exist, here. Now we will branch around the unlock if the ctrlcode
0058 3BEB              * is 6
0059 3BEB              *
0060 3BEB              * 8/31/89           Yee
0061 3BEB              *
0062 3BEB              * Changed the name of routine do_init to do_StatInit. This is to avoid conflict
0063 3BEB              * between other defprocs using this same name. 
0064 3BEB              * Fix bug in INIT routine where the justification field from the template 
0065 3BEB              * is not being copied over to the control record. BRC #51450.
0066 3BEB              *
0067 3BEB              * 5-Apr-91          Dave Lyons
0068 3BEB              *
0069 3BEB              * Added a flag bit to just call DrawText instead of LETextBox2.
0070 3BEB              * It's ctlFlag bit 2 ($0004).  If you set this bit, you must not
0071 3BEB              * include any LETextBox2 formatting commands, and you must not
0072 3BEB              * be doing any substitutions.  They won't be happen.
0073 3BEB              *
0074 3BEB              * 27-Oct-91         Dave Lyons
0075 3BEB              *
0076 3BEB              * Added new ctlFlag bit for static text controls--fTextCanDim,
0077 3BEB              * $0008, makes text dim when it goes inactive.  This is only
0078 3BEB              * useful for small controls, since the text draws first and then
0079 3BEB              * gets wiped over with gray.
0080 3BEB              *
0081 3BEB              * 1-Dec-91          Dave Lyons
0082 3BEB              *
0083 3BEB              * When a Stat Text control with fTextCanDim gets a ctlChangeWinState
0084 3BEB              * message, it must invalidate itself.
0085 3BEB              *
0086 3BEB              * 24-Mar-93         Jim Murphy
0087 3BEB              *
0088 3BEB              * Defined a new ctlFlag bit - fSquishText. If both fBlastText and this
0089 3BEB              * new bit are set, we use DrawStringWidth instead of DrawString.
0090 3BEB              *
0091 3BEB              **********************************************************************
0092 3BEB
0093 3BEB                       blanks off 
0094 3BEB                       string asis 
0095 3BEB
0096 3BEB                       print push 
0097 3BEB                       print off 
0098 3BEB
0099 3BEB                       include 'all.macros' 
0100 3BEB
0101 3BEB                       include 'CtlCustomEqus.asm' 
0102 3BEB                       include 'e16.quickdraw' 
0103 3BEB                       include 'e16.resources' 
0104 3BEB
0105 3BEB              ;
0106 3BEB              ; new ctlFlag bits for Static Text controls in 6.0 (DAL)
0107 3BEB              ;
0108 3BEB              fBlastText equ   $0004
0109 3BEB              fTextCanDim equ   $0008
0110 3BEB
0111 3BEB              ; For 6.0.1 - 23-Mar-93 JCM
0112 3BEB
0113 3BEB              fSquishText equ   $0010                 ;24-Mar-93 JCM
0114 3BEB
0115 3BEB              ;-----------------------------------------------------------
0116 3BEB              ;
0117 3BEB              ; Stack Fram Equates for control
0118 3BEB              ;
0119 3BEB                       DefineStack 
0120 3BEB              OrigD    WORD                           ; caller's saved direct page register
0121 3BEB              OrigB    byte                           ; caller's saved data bank register
0122 3BEB              CtlPtr   LONG                           ; pointer to control record
0123 3BEB              RtnAddr  block 3                        ; RTL address back to Control Manager
0124 3BEB              theCtlHandle LONG                       ; handle to control record
0125 3BEB              CtlParam LONG                           ; add'l parameter passed to DefProc
0126 3BEB              CtlCode  WORD                           ; operation to perform
0127 3BEB              ReturnValue LONG                        ; space for return value to Ctl Mgr.
0128 3BEB
0129 3BEB
0130 3BEB                       print pop 
0131 3BEB
0132 3BEB
0133 3BEB                       title 'StatTextProc -- Main Entry' 
0134 3BEB              ****************************************************************
0135 3BEB              *
0136 3BEB              StatTextProc PROC EXPORT 
0137 3BEB              *
0138 3BEB              * This is the def_proc for static text.  When this
0139 3BEB              * routine gets control, the stack looks as described below.
0140 3BEB              *
0141 3BEB              *
0142 3BEB              *
0143 3BEB              * Inputs:           On entry, the parameters are passed to us on the stack.
0144 3BEB              *
0145 3BEB              *                   |                   | Previous Contents
0146 3BEB              *                   |-------------------|
0147 3BEB              *                   |    ReturnValue    | LONG - Space for return value
0148 3BEB              *                   |-------------------|
0149 3BEB              *                   |    CtlCode        | WORD - operation to perform
0150 3BEB              *                   |-------------------|
0151 3BEB              *                   |    CtlParam       | LONG - add'l parameter
0152 3BEB              *                   |-------------------|
0153 3BEB              *                   |    theCtlHandle   | LONG - Handle to control record
0154 3BEB              *                   |-------------------|
0155 3BEB              *                   |    RtnAddr        | 3 BYTES - RTL address
0156 3BEB              *                   |-------------------|
0157 3BEB              *                   |                   | <-- Stack pointer
0158 3BEB              *
0159 3BEB              * Outputs:          Put something into ReturnValue, pull off the parameters,
0160 3BEB              *                   and return to the Control Manager.
0161 3BEB              *
0162 3BEB              *                   |                   | Previous Contents
0163 3BEB              *                   |-------------------|
0164 3BEB              *                   |    ReturnValue    | LONG - Space for return value
0165 3BEB              *                   |-------------------|
0166 3BEB              *                   |    RtnAddr        | 3 BYTES - RTL address
0167 3BEB              *                   |-------------------|
0168 3BEB              *                   |                   | <-- Stack pointer
0169 3BEB              *
0170 3BEB              * External Refs:
0171 3BEB                       import do_draw 
0172 3BEB                       import do_nothing 
0173 3BEB                       import do_test 
0174 3BEB                       import do_dispose 
0175 3BEB                       import do_StatInit 
0176 3BEB                       import do_recsize 
0177 3BEB                       import do_ChangeState 
0178 3BEB              *
0179 3BEB              * Entry Points:
0180 3BEB              *                   none
0181 3BEB              *
0182 3BEB                       longa on                       ; mode
0183 3BEB                       longi on
0184 3BEB              *
0185 3BEB              ****************************************************************
0186 3BEB
0187 3BEB 48                    pha                            ; push on some room for 'CtlPtr'
0188 3BEC 48                    pha   
0189 3BED
0190 3BED 8B                    phb                            ; save the Data Bank register
0191 3BEE 0B                    phd                            ; save the Direct Page register
0192 3BEF
0193 3BEF 4B                    phk                            ; switch data bank to program bank
0194 3BF0 AB                    plb   
0195 3BF1 3B                    tsc                            ; switch Direct Page into stack
0196 3BF2 5B                    tcd   
0197 3BF3
0198 3BF3 A5 13                 lda   <CtlCode
0199 3BF5 C9 0C 00              cmp   #recSize
0200 3BF8 F0 15                 beq   SkipDeref
0201 3BFA
0202 3BFA A0 04 00              ldy   #4                       ; first lock down the control handle
0203 3BFD B7 0B                 lda   [<theCtlHandle],y
0204 3BFF 09 00 80              ora   #$8000
0205 3C02 97 0B                 sta   [<theCtlHandle],y
0206 3C04
0207 3C04 A7 0B                 lda   [<theCtlHandle]          ; now deref the control handle
0208 3C06 85 04                 sta   <CtlPtr
0209 3C08 A0 02 00              ldy   #2
0210 3C0B B7 0B                 lda   [<theCtlHandle],y
0211 3C0D 85 06                 sta   <CtlPtr+2
0212 3C0F
0213 3C0F              SkipDeref  
0214 3C0F A5 13                 lda   <CtlCode                 ; get routine # to call
0215 3C11 C9 14 00              cmp   #ctlWinStateChange+1     ; make sure the msg is in range.
0216 3C14 90 03                 blt   ShiftIt
0217 3C16 A9 06 00              lda   #6                       ; force unknown codes to null events
0218 3C19              ShiftIt   
0219 3C19 0A                    asl   a
0220 3C1A AA                    tax   
0221 3C1B FC 44 3F              jsr   (ActionTable,x)
0222 3C1E
0223 3C1E 85 15                 sta   <ReturnValue             ; save the return value
0224 3C20 86 17                 stx   <ReturnValue+2
0225 3C22
0226 3C22              ;
0227 3C22              ; 4/13/89 fixed this to only unlock if the handle was locked!
0228 3C22 A5 13                 lda   <CtlCode
0229 3C24 C9 0C 00              cmp   #recSize
0230 3C27 F0 0A                 beq   SkipUnLock
0231 3C29
0232 3C29 A0 04 00              ldy   #4                       ; unlock the control handle
0233 3C2C B7 0B                 lda   [<theCtlHandle],y
0234 3C2E 29 FF 7F              and   #$7FFF
0235 3C31 97 0B                 sta   [<theCtlHandle],y
0236 3C33              SkipUnLock  
0237 3C33              ; ENDOFFIX
0238 3C33
0239 3C33              ;
0240 3C33              ; The Return Value has been stored on the stack, and it is time for us to
0241 3C33              ; return back to the Control Manager. Before we do so, however, we must
0242 3C33              ; remove the parameters that were passed to us on the stack. We do this
0243 3C33              ; by moving the RTL address up just below the Return Value, getting the
0244 3C33              ; stack pointer, and adding an amount to it so that we point to where
0245 3C33              ; the RTL address has been moved to. We can then simply RTL back to the
0246 3C33              ; Control Manager, and it will pick up the Return Value right off of the
0247 3C33              ; stack!
0248 3C33              ;
0249 3C33 A5 08                 lda   <RtnAddr                 ; move the return address up
0250 3C35 85 12                 sta   <ReturnValue-3
0251 3C37 A5 09                 lda   <RtnAddr+1
0252 3C39 85 13                 sta   <ReturnValue-2
0253 3C3B
0254 3C3B 3B                    tsc                            ; Get the stack pointer
0255 3C3C
0256 3C3C 2B                    pld                            ; restore caller's Data Bank and
0257 3C3D AB                    plb                            ; Direct Page registers
0258 3C3E
0259 3C3E 18                    clc                            ; Adjust the stack pointer to point to
0260 3C3F 69 11 00              adc   #ReturnValue-4           ; the new location of the RTL address.
0261 3C42 1B                    tcs                            ; Put the stack pointer back.
0262 3C43
0263 3C43 6B                    rtl                            ; back to the caller
0264 3C44
0265 3C44
0266 3C44              ;
0267 3C44 19 40        ActionTable DC W:do_draw                0 Draw simple button.
0268 3C46 73 3F                 DC W:do_nothing                1 Compute drag RECT.
0269 3C48 DA 3F                 DC W:do_test                   2 Common hit test routine.
0270 3C4A 94 3F                 DC W:do_StatInit               3 Initialize the control.
0271 3C4C 78 3F                 DC W:do_dispose                4 Dispose.
0272 3C4E 19 40                 DC W:do_draw                   5 New value.
0273 3C50 73 3F                 DC W:do_nothing                6 Compute Thumber constrains.
0274 3C52 73 3F                 DC W:do_nothing                7 Drag the indicator.
0275 3C54 73 3F                 DC W:do_nothing                8 Auto action.
0276 3C56 19 40                 DC W:do_draw                   9 New value.
0277 3C58 73 3F                 DC W:do_nothing                10 Set min max.
0278 3C5A 73 3F                 DC W:do_nothing                11 Move button.
0279 3C5C 6C 3F                 DC W:do_recsize                12 Return size of standard record.
0280 3C5E 73 3F                 DC W:do_nothing                13 take key or menu event
0281 3C60 73 3F                 DC W:do_nothing                14 ctlChangeTarget
0282 3C62 73 3F                 DC W:do_nothing                15 ctlChagneBounds
0283 3C64 73 3F                 DC W:do_nothing                16 ctlWindChagneSize
0284 3C66 73 3F                 DC W:do_nothing                17 ctlHandleTab
0285 3C68 73 3F                 DC W:do_nothing                18 ctlNotifyMultiPart
0286 3C6A F5 3F                 DC W:do_ChangeState            19 ctlWinStateChange (1-Dec-91 DAL)
0287 3C6C
0288 3C6C                       ENDP 
0289 3C6C
0290 3C6C                       title 'StatTextProc -- do_recsize' 
0291 3C6C              ****************************************************************
0292 3C6C              *
0293 3C6C              do_recsize PROC 
0294 3C6C              *
0295 3C6C              * Returns the size of the control record.  This is the
0296 3C6C              * normal size of a new control record.  
0297 3C6C              *
0298 3C6C              * Note that the high word will always be 0.
0299 3C6C              *
0300 3C6C              *
0301 3C6C              * Inputs:
0302 3C6C              *                   none
0303 3C6C              *
0304 3C6C              * Outputs:
0305 3C6C              *                   a-reg & x-reg hold result for def proc
0306 3C6C              *
0307 3C6C              * External Refs:
0308 3C6C              *                   none
0309 3C6C              *
0310 3C6C              * Entry Points:
0311 3C6C              *                   none
0312 3C6C              *
0313 3C6C                       longa on                       ; mode
0314 3C6C                       longi on
0315 3C6C              *
0316 3C6C              ****************************************************************
0317 3C6C
0318 3C6C A9 40 00              lda   #superCtlSize
0319 3C6F A2 00 00              ldx   #0                       High word of size.
0320 3C72
0321 3C72 60                    rts   
0322 3C73
0323 3C73                       ENDP 
0324 3C73
0325 3C73                       title 'StatTextProc -- do_nothing' 
0326 3C73              ****************************************************************
0327 3C73              *
0328 3C73              do_nothing PROC 
0329 3C73              *
0330 3C73              * This is the routine we use when there is nothing to do.
0331 3C73              * It just returns zeros in the a and x registers.
0332 3C73              *
0333 3C73              *
0334 3C73              * Inputs:
0335 3C73              *                   ctlHandle
0336 3C73              *                   ctlPtr
0337 3C73              *
0338 3C73              * Outputs:
0339 3C73              *                   a-reg & x-reg hold result for def proc
0340 3C73              *
0341 3C73              * External Refs:
0342 3C73              *                   none
0343 3C73              *
0344 3C73              * Entry Points:
0345 3C73              *                   none
0346 3C73              *
0347 3C73                       longa on                       ; mode
0348 3C73                       longi on
0349 3C73              *
0350 3C73              ****************************************************************
0351 3C73
0352 3C73              ;
0353 3C73 A9 00 00              lda   #0                       Nothing flag.
0354 3C76 AA                    tax   
0355 3C77
0356 3C77 60                    rts   
0357 3C78
0358 3C78                       ENDP 
0359 3C78
0360 3C78                       title 'StatTextProc -- do_dispose' 
0361 3C78              ****************************************************************
0362 3C78              *
0363 3C78              do_dispose PROC  
0364 3C78              *
0365 3C78              * This is the routine we use when the control is disposed.
0366 3C78              * The only thing this routine has to do is to release the 
0367 3C78              * resource if the text is referenced by resource.
0368 3C78              *
0369 3C78              *
0370 3C78              * Inputs:
0371 3C78              *                   ctlHandle
0372 3C78              *                   ctlPtr
0373 3C78              *
0374 3C78              * Outputs:
0375 3C78              *                   a-reg & x-reg hold result for def proc
0376 3C78              *
0377 3C78              * External Refs:
0378 3C78                       import CtlDataToAX 
0379 3C78                       import GetRefType 
0380 3C78              *
0381 3C78              * Entry Points:
0382 3C78              *                   none
0383 3C78              *
0384 3C78                       longa on                       ; mode
0385 3C78                       longi on
0386 3C78              *
0387 3C78              ****************************************************************
0388 3C78
0389 3C78 20 78 43              jsr   GetRefType
0390 3C7B
0391 3C7B C9 02 00              cmp   #$0002
0392 3C7E D0 0F                 bne   NotResource
0393 3C80
0394 3C80 F4 0B 80              PushWord #rTextForLETextBox2   ; type
0395 3C83 20 6D 43              jsr   CtlDataToAX
0396 3C86 DA                    phx   
0397 3C87 48                    pha   
0398 3C88 A2 10 33 22           _CMReleaseResource 
0399 3C8F
0400 3C8F              NotResource  
0401 3C8F              ;
0402 3C8F A9 00 00              lda   #0                       Nothing flag.
0403 3C92 AA                    tax   
0404 3C93
0405 3C93 60                    rts   
0406 3C94
0407 3C94                       ENDP 
0408 3C94
0409 3C94                       title 'StatTextProc -- do_StatInit' 
0410 3C94              ****************************************************************
0411 3C94              *
0412 3C94              do_StatInit PROC EXPORT 
0413 3C94              *
0414 3C94              * Inits the data and value fields in the control record
0415 3C94              * using values in the template.
0416 3C94              *
0417 3C94              * Also looks for the ctlJust field if the pCount is at least 9.
0418 3C94              *
0419 3C94              * The ctlData field is set to be a reference to the static text
0420 3C94              * and the ctlValue field is set to be the size of the static
0421 3C94              * text field (if the ref is a pointer).
0422 3C94              *
0423 3C94              *
0424 3C94              * Inputs:
0425 3C94              *                   ctlHandle
0426 3C94              *                   ctlPtr
0427 3C94              *                   ctlParam = ptr to template
0428 3C94              *
0429 3C94              * Outputs:
0430 3C94              *                   a-reg and x-reg are zero.
0431 3C94              *
0432 3C94              * External Refs:
0433 3C94                       import GetRefType 
0434 3C94              *
0435 3C94              * Entry Points:
0436 3C94              *                   none
0437 3C94              *
0438 3C94                       longa on                       ; mode
0439 3C94                       longi on
0440 3C94              *
0441 3C94              * Change History
0442 3C94              *
0443 3C94              * 06 Feb 89         Steven Glass
0444 3C94              *
0445 3C94              * Added support for the optional justification field in the
0446 3C94              * template.
0447 3C94              *
0448 3C94              ****************************************************************
0449 3C94
0450 3C94 20 78 43              jsr   GetRefType               ; low 2 bits of flag in a-reg
0451 3C97 C9 00 00              cmp   #0
0452 3C9A D0 0A                 bne   NotAPtr
0453 3C9C
0454 3C9C A0 1E 00              ldy   #StatTextTemplate.TextSize
0455 3C9F B7 0F                 lda   [<ctlParam],y
0456 3CA1 A0 12 00              ldy   #NewCtlRecord.ctlValue
0457 3CA4 97 04                 sta   [<ctlPtr],y
0458 3CA6
0459 3CA6              NotAPtr   
0460 3CA6 A0 1A 00              ldy   #StatTextTemplate.TextRef
0461 3CA9 B7 0F                 lda   [<ctlParam],y
0462 3CAB AA                    tax   
0463 3CAC C8                    iny   
0464 3CAD C8                    iny   
0465 3CAE B7 0F                 lda   [<ctlParam],y
0466 3CB0
0467 3CB0 A0 1E 00              ldy   #NewCtlRecord.ctlData+2
0468 3CB3 97 04                 sta   [<ctlPtr],y
0469 3CB5 88                    dey   
0470 3CB6 88                    dey   
0471 3CB7 8A                    txa   
0472 3CB8 97 04                 sta   [<ctlPtr],y
0473 3CBA
0474 3CBA
0475 3CBA A0 28 00              ldy   #NewCtlRecord.CtlJust    ; init the just word
0476 3CBD A9 00 00              lda   #0
0477 3CC0 97 04                 sta   [<ctlPtr],y
0478 3CC2 BB                    tyx                            ; save offset in x
0479 3CC3
0480 3CC3 A0 00 00              ldy   #StatTextTemplate.pCount ; check the p count
0481 3CC6 B7 0F                 lda   [<ctlParam],y
0482 3CC8 C9 09 00              cmp   #9
0483 3CCB 90 08                 bcc   Fini
0484 3CCD
0485 3CCD A0 20 00              ldy   #StatTextTemplate.Just   ; move the real value
0486 3CD0 B7 0F                 lda   [<ctlParam],y            ; into place
0487 3CD2 9B                    txy                            ; using saved offset.
0488 3CD3 97 04                 sta   [<ctlPtr],y
0489 3CD5
0490 3CD5              Fini      
0491 3CD5 A9 00 00              lda   #0
0492 3CD8 AA                    tax   
0493 3CD9 60                    rts   
0494 3CDA
0495 3CDA
0496 3CDA
0497 3CDA                       ENDP 
0498 3CDA
0499 3CDA                       title 'StatTextProc -- do_test' 
0500 3CDA              ****************************************************************
0501 3CDA              *
0502 3CDA              do_test  PROC 
0503 3CDA              *
0504 3CDA              * Test if the mouse is down in the control.  We always
0505 3CDA              * return no, since it does not make sense to "click" on
0506 3CDA              * static text.
0507 3CDA              *
0508 3CDA              *
0509 3CDA              * Inputs:
0510 3CDA              *                   ctlParam = point to check
0511 3CDA              *
0512 3CDA              *
0513 3CDA              * Outputs:
0514 3CDA              *                   a-reg and x-reg are always zero
0515 3CDA              *
0516 3CDA              * External Refs:
0517 3CDA              *                   none
0518 3CDA              *
0519 3CDA              * Entry Points:
0520 3CDA              *                   none
0521 3CDA              *
0522 3CDA                       longa on                       ; mode
0523 3CDA                       longi on
0524 3CDA              *
0525 3CDA              ****************************************************************
0526 3CDA
0527 3CDA A0 11 00              ldy   #NewCtlRecord.ctlHilite
0528 3CDD B7 04                 lda   [ctlPtr],y
0529 3CDF 29 FF 00              and   #$00FF
0530 3CE2 C9 FF 00              cmp   #$00FF
0531 3CE5 F0 07                 beq   Inactive
0532 3CE7
0533 3CE7 A9 01 00              lda   #1
0534 3CEA A2 00 00              ldx   #0
0535 3CED 60                    rts   
0536 3CEE
0537 3CEE
0538 3CEE              Inactive  
0539 3CEE A9 00 00              lda   #0
0540 3CF1 A2 00 00              ldx   #0
0541 3CF4
0542 3CF4 60                    rts   
0543 3CF5
0544 3CF5                       ENDP 
0545 3CF5
0546 3CF5              *** added 1-Dec-91 DAL
0547 3CF5                       title 'StatTextProc -- do_ChangeState' 
0548 3CF5              ****************************************************************
0549 3CF5              *
0550 3CF5              do_ChangeState PROC 
0551 3CF5              *
0552 3CF5              * Called when our window gets activated or inactivated.  If
0553 3CF5              * the fTextCanDim bit is set, then invalidate the control
0554 3CF5              * rectangle so it will redraw.
0555 3CF5              *
0556 3CF5              * Inputs:
0557 3CF5              *                   ctlPtr
0558 3CF5              *
0559 3CF5              * Outputs:
0560 3CF5              *                   a-reg and x-reg are zero.
0561 3CF5              *
0562 3CF5              ****************************************************************
0563 3CF5
0564 3CF5 A0 10 00              ldy   #NewCtlRecord.ctlFlag
0565 3CF8 B7 04                 lda   [<CtlPtr],y
0566 3CFA 29 08 00              and   #fTextCanDim
0567 3CFD F0 15                 beq   @exit
0568 3CFF
0569 3CFF A5 04                 lda   <ctlPtr
0570 3D01 18                    clc   
0571 3D02 69 08 00              adc   #NewCtlRecord.ctlRect
0572 3D05 AA                    tax   
0573 3D06 A5 06                 lda   <ctlPtr+2
0574 3D08 69 00 00              adc   #0
0575 3D0B 48                    pha   
0576 3D0C DA                    phx   
0577 3D0D A2 0E 3A 22           _InvalRect 
0578 3D14
0579 3D14 A9 00 00     @exit    lda   #0
0580 3D17 AA                    tax   
0581 3D18 60                    rts   
0582 3D19
0583 3D19                       EndP 
0584 3D19              *** end 1-Dec-91 DAL
0585 3D19
0586 3D19                       title 'StatTextProc -- do_draw' 
0587 3D19              ****************************************************************
0588 3D19              *
0589 3D19              do_draw  PROC 
0590 3D19              *
0591 3D19              * Draws the control using LETextBox2.  The control is only
0592 3D19              * drawn if the part code being passed is 0, indicating the
0593 3D19              * whole control.
0594 3D19              *
0595 3D19              *
0596 3D19              * Inputs:
0597 3D19              *                   ctlHandle
0598 3D19              *                   ctlPtr
0599 3D19              *
0600 3D19              * Outputs:
0601 3D19              *                   a-reg and x-reg are zero.
0602 3D19              *
0603 3D19              * External Refs:
0604 3D19                       import CtlDataToAX 
0605 3D19                       import GetRefType 
0606 3D19              *
0607 3D19              * Entry Points:
0608 3D19              *                   none
0609 3D19              *
0610 3D19                       longa on                       ; mode
0611 3D19                       longi on
0612 3D19              *
0613 3D19              *
0614 3D19              * Change History
0615 3D19              *
0616 3D19              * 06 Feb 89         Steven Glass
0617 3D19              *
0618 3D19              * The control handle was not being re-derefed twice where 
0619 3D19              * memory could have moved:   once after compiling text and
0620 3D19              * once after drawing the text.
0621 3D19              *
0622 3D19              * Added new feature to drawing: the programmer can set
0623 3D19              * a value for the initial justification.  This value is 
0624 3D19              * kept in the ctlJust field of the control record.
0625 3D19              *
0626 3D19              ****************************************************************
0627 3D19
0628 3D19              ;-----------------------------------------------------------
0629 3D19              ;
0630 3D19              ; Look at the part code.  If it is not 0, this is a request
0631 3D19              ; to hilite the control (which we ignore).
0632 3D19              ;
0633 3D19 A5 0F                 lda   ctlParam
0634 3D1B F0 03                 beq   @cont
0635 3D1D 82 E1 02              brl   Fini
0636 3D20
0637 3D20              @cont     
0638 3D20
0639 3D20              *
0640 3D20              * 5-Apr-91 DAL
0641 3D20              *
0642 3D20              * See if we should just do a DrawString to draw this control
0643 3D20              * really fast
0644 3D20              *
0645 3D20 A0 10 00              ldy   #NewCtlRecord.ctlFlag
0646 3D23 B7 04                 lda   [ctlPtr],y
0647 3D25 29 04 00              and   #fBlastText
0648 3D28
0649 3D28              *** Added - 23-Mar-93 JCM - Use DrawStringWidth if both fBlastText and fSquishText
0650 3D28              ***                           bits are set.
0651 3D28
0652 3D28              ;;;	beq	@notFast
0653 3D28 D0 03                 bne   @tryJimsWay
0654 3D2A
0655 3D2A 82 8E 01              brl   @notFast
0656 3D2D
0657 3D2D A0 0A 00     @tryJimsWay ldy   #NewCtlRecord.ctlRect+2 ;left edge
0658 3D30 B7 04                 lda   [<ctlPtr],y
0659 3D32 48                    pha   
0660 3D33 88                    dey   
0661 3D34 88                    dey                            ;offset to rect top
0662 3D35 B7 04                 lda   [ctlPtr],y
0663 3D37 18                    clc   
0664 3D38 69 08 00              adc   #8
0665 3D3B 48                    pha   
0666 3D3C A2 04 3A 22           _MoveTo 
0667 3D43
0668 3D43 A0 10 00              ldy   #NewCtlRecord.ctlFlag
0669 3D46 B7 04                 lda   [ctlPtr],y
0670 3D48 29 10 00              and   #fSquishText             ;should we call DrawStringWidth?
0671 3D4B D0 03                 bne   @doItJimsWay
0672 3D4D
0673 3D4D 82 4D 01              brl   @blastDavesWay           ; nope, be boring
0674 3D50
0675 3D50 48           @doItJimsWay pha   
0676 3D51 48                    pha                            ;space for ConvertRefToPtr result
0677 3D52 20 78 43              jsr   GetRefType
0678 3D55 48                    pha   
0679 3D56 20 6D 43              jsr   CtlDataToAX
0680 3D59 DA                    phx   
0681 3D5A 48                    pha   
0682 3D5B 20 06 43              jsr   ConvertRefToPtr          ;source ptr
0683 3D5E F4 02 00              pea   @tempStringBuf>>16
0684 3D61 F4 9E 40              pea   @tempStringBuf+1         ;dest ptr
0685 3D64 F4 00 00              PushWord #0 
0686 3D67 A0 12 00              ldy   #NewCtlRecord.ctlValue
0687 3D6A B7 04                 lda   [<CtlPtr],y
0688 3D6C 8D 9D 40              sta   @tempStringBuf           ;save length byte
0689 3D6F 29 FF 00              and   #$00FF                   ;force to be a pstring
0690 3D72 48                    pha                            ;length
0691 3D73 A2 02 2B 22           _BlockMove 
0692 3D7A
0693 3D7A 20 78 43              jsr   GetRefType
0694 3D7D 09 00 60              ora   #$6000                   ;flags - truncate left/pstring
0695 3D80 48                    pha   
0696 3D81 F4 02 00              pea   @tempStringBuf>>16
0697 3D84 F4 9D 40              pea   @tempStringBuf           ;stringRef
0698 3D87 A0 0E 00              ldy   #NewCtlRecord.ctlRect+6  ;right edge
0699 3D8A B7 04                 lda   [<ctlPtr],y
0700 3D8C 38                    sec   
0701 3D8D A0 0A 00              ldy   #NewCtlRecord.ctlRect+2  ;left edge
0702 3D90 F7 04                 sbc   [<ctlPtr],y
0703 3D92 48                    pha                            ;width
0704 3D93 A2 12 15              ldx   #$1512
0705 3D96 22 00 00 E1           jsl   $E10000
0706 3D9A              ;	_DrawStringWidth
0707 3D9A
0708 3D9A 82 DC 01              brl   CleanUp
0709 3D9D
0710 3D9D 00 00 00 00  @tempStringBuf DS B:256
0711 3E9D
0712 3E9D              @blastDavesWay                          ;the old, the boring, the Dave
0713 3E9D
0714 3E9D              ;	ldy	#NewCtlRecord.ctlRect+2	;left edge
0715 3E9D              ;	lda	[<ctlPtr],y
0716 3E9D              ;	pha
0717 3E9D              ;	dey
0718 3E9D              ;	dey		;offset to rect top
0719 3E9D              ;	lda	[ctlPtr],y
0720 3E9D              ;	clc
0721 3E9D              ;	adc	#8
0722 3E9D              ;	pha
0723 3E9D              ;	_MoveTo
0724 3E9D
0725 3E9D              *** End - 23-Mar-93 JCM
0726 3E9D
0727 3E9D 48                    pha   
0728 3E9E 48                    pha                            ;space for ConvertRefToPtr result
0729 3E9F 20 78 43              jsr   GetRefType
0730 3EA2 48                    pha   
0731 3EA3 20 6D 43              jsr   CtlDataToAX
0732 3EA6 DA                    phx   
0733 3EA7 48                    pha   
0734 3EA8 20 06 43              jsr   ConvertRefToPtr
0735 3EAB A0 12 00              ldy   #NewCtlRecord.ctlValue   ; text length
0736 3EAE B7 04                 lda   [<CtlPtr],y
0737 3EB0 48                    pha   
0738 3EB1 A2 04 A7 22           _DrawText 
0739 3EB8 82 BE 00              brl   CleanUp
0740 3EBB
0741 3EBB              @notFast  
0742 3EBB              *** end of 5-Apr-91 DAL
0743 3EBB
0744 3EBB              ;-----------------------------------------------------------
0745 3EBB              ;
0746 3EBB              ; See if we need to do substitution on the text.
0747 3EBB              ;
0748 3EBB
0749 3EBB A0 10 00              ldy   #NewCtlRecord.ctlFlag
0750 3EBE B7 04                 lda   [ctlPtr],y
0751 3EC0 29 02 00              and   #FSubstituteText
0752 3EC3 D0 03                 bne   MakeSubs
0753 3EC5
0754 3EC5 82 82 00              brl   NoSubs
0755 3EC8
0756 3EC8              MakeSubs  
0757 3EC8
0758 3EC8              ; TextHandle := CompileText (SubType, SubArrayPtr, OrigTextPtr, OrigTextSize)
0759 3EC8
0760 3EC8 48                    pha                            ; space for handle
0761 3EC9 48                    pha   
0762 3ECA B7 04                 lda   [ctlPtr],y               ; type of text
0763 3ECC 29 01 00              and   #FSubTextType
0764 3ECF 48                    pha   
0765 3ED0 48                    pha                            ; pointer to sub array
0766 3ED1 48                    pha   
0767 3ED2 A2 10 35 22           _GetCtlParamPtr 
0768 3ED9 48                    pha                            ; pointer to text
0769 3EDA 48                    pha   
0770 3EDB
0771 3EDB 20 78 43              jsr   GetRefType
0772 3EDE 48                    pha   
0773 3EDF 20 6D 43              jsr   CtlDataToAX
0774 3EE2 DA                    phx   
0775 3EE3 48                    pha   
0776 3EE4 20 06 43              jsr   ConvertRefToPtr
0777 3EE7 A0 12 00              ldy   #NewCtlRecord.ctlValue   ; text length
0778 3EEA B7 04                 lda   [<CtlPtr],y
0779 3EEC 48                    pha   
0780 3EED A2 0E 60 22           _CompileText 
0781 3EF4 68 85 0F 68           PullLong CtlParam              ; Put resulting handle into CtlParam
0782 3EFA
0783 3EFA 48                    pha                            ; Get handle's size.
0784 3EFB 48                    pha   
0785 3EFC D4 11                 pei   CtlParam+2
0786 3EFE D4 0F                 pei   Ctlparam
0787 3F00 A2 02 18 22           _GetHandleSize 
0788 3F07
0789 3F07 68                    pla                            ; get size of handle off the stack
0790 3F08 FA                    plx   
0791 3F09 48                    pha                            ; put it on the stack 3 times
0792 3F0A 48                    pha   
0793 3F0B 48                    pha   
0794 3F0C
0795 3F0C              ; Three copies of text size now on stack.  First two will be over written by
0796 3F0C              ; Pointer to text.
0797 3F0C
0798 3F0C A0 04 00              ldy   #4                       ; lock compiled text
0799 3F0F B7 0F                 lda   [ctlParam],y
0800 3F11 09 00 80              ora   #$8000
0801 3F14 97 0F                 sta   [ctlParam],y
0802 3F16 88                    dey   
0803 3F17 88                    dey   
0804 3F18 B7 0F                 lda   [ctlParam],y
0805 3F1A AA                    tax   
0806 3F1B A7 0F                 lda   [ctlParam]
0807 3F1D 83 03                 sta   3,s                      ; Handle^ goes on stack above size word
0808 3F1F 8A                    txa   
0809 3F20 83 05                 sta   5,s
0810 3F22
0811 3F22 A5 04                 lda   <CtlPtr                  ; rect pointer
0812 3F24 18                    clc   
0813 3F25 69 08 00              adc   #NewCtlRecord.ctlRect
0814 3F28 AA                    tax   
0815 3F29 A5 06                 lda   <CtlPtr+2
0816 3F2B 69 00 00              adc   #0
0817 3F2E 48                    pha   
0818 3F2F DA                    phx   
0819 3F30
0820 3F30 A0 28 00              ldy   #NewCtlRecord.CtlJust
0821 3F33 B7 04                 lda   [<CtlPtr],y
0822 3F35 48                    pha   
0823 3F36 A2 14 20 22           _LETextBox2 
0824 3F3D
0825 3F3D D4 11                 pei   CtlParam+2
0826 3F3F D4 0F                 pei   CtlParam
0827 3F41 A2 02 10 22           _DisposeHandle 
0828 3F48
0829 3F48 80 2F                 bra   CleanUp
0830 3F4A
0831 3F4A              NoSubs    
0832 3F4A              ;-----------------------------------------------------------
0833 3F4A              ;
0834 3F4A              ; LeTextBox2 (TextPtr,TextSize,RectPtr,LeftJust)
0835 3F4A              ;
0836 3F4A 48                    pha   
0837 3F4B 48                    pha                            ; space for result
0838 3F4C
0839 3F4C 20 78 43              jsr   GetRefType
0840 3F4F 48                    pha   
0841 3F50 20 6D 43              jsr   CtlDataToAX
0842 3F53 DA                    phx   
0843 3F54 48                    pha   
0844 3F55 20 06 43              jsr   ConvertRefToPtr
0845 3F58
0846 3F58 A0 12 00              ldy   #NewCtlRecord.ctlValue   ; text length
0847 3F5B B7 04                 lda   [<CtlPtr],y
0848 3F5D 48                    pha   
0849 3F5E
0850 3F5E A5 04                 lda   <CtlPtr                  ; rect pointer
0851 3F60 18                    clc   
0852 3F61 69 08 00              adc   #NewCtlRecord.ctlRect
0853 3F64 AA                    tax   
0854 3F65 A5 06                 lda   <CtlPtr+2
0855 3F67 69 00 00              adc   #0
0856 3F6A 48                    pha   
0857 3F6B DA                    phx   
0858 3F6C
0859 3F6C A0 28 00              ldy   #NewCtlRecord.CtlJust
0860 3F6F B7 04                 lda   [<CtlPtr],y
0861 3F71 48                    pha   
0862 3F72 A2 14 20 22           _LETextBox2 
0863 3F79
0864 3F79              ;
0865 3F79              ; CleanUp -- common exit point for both BlastText and normal
0866 3F79              ;
0867 3F79              CleanUp   
0868 3F79              *** added 27-Oct-91 DAL -- dim out the text if needed
0869 3F79 A5 11                 lda   <ctlParam+2              ;high word = $FFFF to dim
0870 3F7B 10 5C                 bpl   @noDim
0871 3F7D
0872 3F7D A0 10 00              ldy   #NewCtlRecord.ctlFlag
0873 3F80 B7 04                 lda   [<ctlPtr],y
0874 3F82 29 08 00              and   #fTextCanDim
0875 3F85 F0 52                 beq   @noDim
0876 3F87
0877 3F87 F4 02 00              pea   @dimmedMask>>16
0878 3F8A F4 B1 42              pea   @dimmedMask
0879 3F8D A2 04 32 22           _SetPenMask 
0880 3F94
0881 3F94 A5 04                 lda   <CtlPtr                  ; rect pointer
0882 3F96 18                    clc   
0883 3F97 69 08 00              adc   #NewCtlRecord.ctlRect
0884 3F9A AA                    tax   
0885 3F9B A5 06                 lda   <CtlPtr+2
0886 3F9D 69 00 00              adc   #0
0887 3FA0 48                    pha   
0888 3FA1 DA                    phx                            ;pushed control rectangle
0889 3FA2 F4 02 00              pea   @whitePatt>>16
0890 3FA5 F4 B9 42              pea   @whitePatt
0891 3FA8 A2 04 57 22           _FillRect 
0892 3FAF 80 28                 bra   @done
0893 3FB1
0894 3FB1 55 AA 55 AA  @dimmedMask DC B:$55,$aa,$55,$aa,$55,$aa,$55,$aa
0895 3FB9 FF FF FF FF  @whitePatt DC B:$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
0896 3FC1 FF FF FF FF           DC B:$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
0897 3FC9 FF FF FF FF           DC B:$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
0898 3FD1 FF FF FF FF           DC B:$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
0899 3FD9
0900 3FD9              @done     
0901 3FD9              @noDim    
0902 3FD9              *** end 27-Oct-91
0903 3FD9
0904 3FD9              ;-----------------------------------------------------------
0905 3FD9              ;
0906 3FD9              ; Unlock anything we locked coming in.
0907 3FD9              ;
0908 3FD9 20 78 43              jsr   GetRefType
0909 3FDC AA                    tax   
0910 3FDD F0 22                 beq   Fini
0911 3FDF
0912 3FDF C9 01 00              cmp   #$0001
0913 3FE2 F0 08                 beq   @UnlockHandle
0914 3FE4
0915 3FE4 20 6D 43              jsr   CtlDataToAX
0916 3FE7 20 5C 43              jsr   GetResourceHandle
0917 3FEA 80 03                 bra   @UnlockIt
0918 3FEC
0919 3FEC 20 6D 43     @UnlockHandle jsr   CtlDataToAX
0920 3FEF DA           @UnlockIt phx   
0921 3FF0 48                    pha   
0922 3FF1 0B                    phd   
0923 3FF2 3B                    tsc   
0924 3FF3 5B                    tcd   
0925 3FF4 A0 04 00              ldy   #4
0926 3FF7 B7 03                 lda   [3],y
0927 3FF9 29 FF 7F              and   #$7FFF
0928 3FFC 97 03                 sta   [3],y
0929 3FFE 2B                    pld   
0930 3FFF 68                    pla   
0931 4000 68                    pla   
0932 4001
0933 4001              oops      
0934 4001              ;-----------------------------------------------------------
0935 4001              ;
0936 4001              ; Return nothing
0937 4001              ;
0938 4001 A9 00 00     Fini     lda   #0
0939 4004 AA                    tax   
0940 4005 60                    rts   
0941 4006
0942 4006
0943 4006
0944 4006
0945 4006              ConvertRefToPtr  
0946 4006                       DefineStack 
0947 4006              RTS      word 
0948 4006              TheRef   long 
0949 4006              TheVerb  word 
0950 4006              ThePtr   long 
0951 4006
0952 4006 A3 07                 lda   TheVerb,s
0953 4008 29 03 00              and   #$0003
0954 400B F0 45                 beq   @AlreadyPtr
0955 400D
0956 400D C9 01 00              cmp   #1
0957 4010 F0 0D                 beq   @ItsHandle
0958 4012
0959 4012              @ItsResource  
0960 4012 A3 05                 lda   TheRef+2,s
0961 4014 AA                    tax   
0962 4015 A3 03                 lda   TheRef,s
0963 4017 20 5C 43              jsr   GetResourceHandle
0964 401A 83 03                 sta   TheRef,s
0965 401C 8A                    txa   
0966 401D 83 05                 sta   TheRef+2,s
0967 401F
0968 401F 3B           @ItsHandle tsc   
0969 4020 0B                    phd   
0970 4021 5B                    tcd   
0971 4022 A0 04 00              ldy   #4
0972 4025 B7 03                 lda   [TheRef],y
0973 4027 09 00 80              ora   #$8000
0974 402A 97 03                 sta   [TheRef],y
0975 402C A7 03                 lda   [TheRef]
0976 402E 85 09                 sta   ThePtr
0977 4030 88                    dey   
0978 4031 88                    dey   
0979 4032 B7 03                 lda   [TheRef],y
0980 4034 85 0B                 sta   ThePtr+2
0981 4036
0982 4036 48                    pha   
0983 4037 48                    pha   
0984 4038 D4 05                 pei   TheRef+2
0985 403A D4 03                 pei   TheRef
0986 403C A2 02 18 22           _GetHandleSize 
0987 4043 FA                    plx   
0988 4044 68                    pla   
0989 4045
0990 4045 2B                    pld   
0991 4046
0992 4046 A0 12 00              ldy   #NewCtlRecord.ctlValue
0993 4049 8A                    txa   
0994 404A 97 04                 sta   [<ctlPtr],y
0995 404C
0996 404C FA           @Strip   plx   
0997 404D 68                    pla   
0998 404E 68                    pla   
0999 404F 68                    pla   
1000 4050 DA                    phx   
1001 4051 60                    rts   
1002 4052
1003 4052
1004 4052
1005 4052              @AlreadyPtr  
1006 4052 A3 03                 lda   TheRef,s
1007 4054 83 09                 sta   ThePtr,s
1008 4056 A3 05                 lda   TheRef+2,s
1009 4058 83 0B                 sta   ThePtr+2,s
1010 405A 80 F0                 bra   @Strip
1011 405C
1012 405C
1013 405C              GetResourceHandle  
1014 405C 48                    pha   
1015 405D 48                    pha   
1016 405E F4 0B 80              PushWord #rTextForLETextBox2   ; type
1017 4061 DA                    phx   
1018 4062 48                    pha   
1019 4063 A2 10 32 22           _CMLoadResource 
1020 406A
1021 406A 68                    pla   
1022 406B FA                    plx   
1023 406C 60                    rts   
1024 406D
1025 406D
1026 406D                       ENDP 
1027 406D
1028 406D                       title 'StatTextProc -- Utils' 
1029 406D              ****************************************************************
1030 406D              *
1031 406D              UsefulUtils PROC 
1032 406D              *
1033 406D              * Description
1034 406D              *
1035 406D              *
1036 406D              * Inputs:
1037 406D              *                   none
1038 406D              *
1039 406D              * Outputs:
1040 406D              *                   none
1041 406D              *
1042 406D              * External Refs:
1043 406D              *                   none
1044 406D              *
1045 406D              * Entry Points:
1046 406D              *
1047 406D                       longa on                       ; mode
1048 406D                       longi on
1049 406D              *
1050 406D              ****************************************************************
1051 406D
1052 406D
1053 406D
1054 406D              ;-----------------------------------------------------------
1055 406D              ;
1056 406D              ; Returns the value in ctlData in A and X registers.
1057 406D              ;
1058 406D                       ENTRY CtlDataToAX 
1059 406D              CtlDataToAX  
1060 406D A0 1E 00              ldy   #NewCtlRecord.ctlData+2
1061 4070 B7 04                 lda   [ctlPtr],y
1062 4072 AA                    tax   
1063 4073 88                    dey   
1064 4074 88                    dey   
1065 4075 B7 04                 lda   [ctlPtr],y
1066 4077 60                    rts   
1067 4078
1068 4078
1069 4078              ;-----------------------------------------------------------
1070 4078              ;
1071 4078              ; Returns the text Ref verb in a-reg.
1072 4078              ;
1073 4078                       Import GetRefType 
1074 4078              GetRefType PROC EXPORT 
1075 4078 A0 3C 00              ldy   #NewCtlRecord.ctlMoreFlags
1076 407B B7 04                 lda   [ctlPtr],y
1077 407D 29 03 00              and   #$0003
1078 4080 60                    rts   
1079 4081
1080 4081                       ENDP 
1081 4081
1082 4081                       END   
